<?php
session_start();
include 'conexao.php';

// Verifica se o usuário é administrador
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'ADMINISTRADOR') {
    header("Location: login.php");
    exit;
}

$sucesso = "";
$erro = "";

// Inserção do aviso
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo = trim($_POST['titulo'] ?? '');
    $conteudo = trim($_POST['conteudo'] ?? '');

    if ($titulo && $conteudo) {
        $stmt = $conn->prepare("INSERT INTO avisos (titulo, conteudo, data_publicacao) VALUES (?, ?, NOW())");
        $stmt->bind_param("ss", $titulo, $conteudo);
        if ($stmt->execute()) {
            $sucesso = "✅ Aviso publicado com sucesso!";
        } else {
            $erro = "❌ Erro ao salvar o aviso.";
        }
    } else {
        $erro = "⚠️ Preencha todos os campos.";
    }
}

// Lista de últimos avisos
$avisos = [];
$result = $conn->query("SELECT * FROM avisos ORDER BY data_publicacao DESC LIMIT 10");
while ($row = $result->fetch_assoc()) {
    $avisos[] = $row;
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Publicar Avisos</title>
    <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f2f2f2;
            margin: 0;
            padding: 30px;
        }
        .container {
            background: white;
            max-width: 700px;
            margin: auto;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.15);
        }
        h2 {
            color: #003366;
            margin-bottom: 20px;
        }
        label {
            font-weight: bold;
            display: block;
            margin-top: 10px;
        }
        input[type="text"], textarea {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        textarea {
            resize: vertical;
            height: 100px;
        }
        button {
            margin-top: 15px;
            background: #003366;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
        }
        button:hover {
            background: #005499;
        }
        .mensagem {
            margin-top: 10px;
            font-weight: bold;
            padding: 10px;
            border-radius: 6px;
        }
        .erro {
            color: #721c24;
            background: #f8d7da;
            border: 1px solid #f5c6cb;
        }
        .sucesso {
            color: #155724;
            background: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .aviso-item {
            background: #f9f9f9;
            margin-top: 15px;
            padding: 15px;
            border-left: 5px solid #003366;
        }
        .aviso-item small {
            color: #666;
        }
    </style>
</head>
<body>
<div class="container">
    <h2><i class="fas fa-bullhorn"></i> Publicar Aviso aos Alunos</h2>

    <?php if ($erro): ?>
        <div class="mensagem erro"><?= $erro ?></div>
    <?php elseif ($sucesso): ?>
        <div class="mensagem sucesso"><?= $sucesso ?></div>
    <?php endif; ?>

    <form method="POST">
        <label for="titulo">Título</label>
        <input type="text" name="titulo" id="titulo" required>

        <label for="conteudo">Conteúdo</label>
        <textarea name="conteudo" id="conteudo" required></textarea>

        <button type="submit"><i class="fas fa-paper-plane"></i> Publicar Aviso</button>
    </form>

    <hr>

    <h3>🗒 Últimos Avisos</h3>
    <?php if (empty($avisos)): ?>
        <p>Nenhum aviso publicado ainda.</p>
    <?php else: ?>
        <?php foreach ($avisos as $a): ?>
            <div class="aviso-item">
                <strong><?= htmlspecialchars($a['titulo']) ?></strong><br>
                <small>Publicado em: <?= date('d/m/Y', strtotime($a['data_publicacao'])) ?></small>
                <p><?= nl2br(htmlspecialchars($a['conteudo'])) ?></p>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
</body>
</html>
